	function [s11, s21] = CT_TREE_WDF_BP_H(alfa, wT)
	
	% 	Computes the frequency response of an odd order bandpass
	%	circulator-tree wave digital filter consisting of 
	%	three- and four-port adaptors. The first coefficient
	%	is the first-order section.  
	
	%	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 			Lars Wanhammar 2009-11-15
	% 	Modified by: 	 	LW 2011-07-04, 2014-08-23
	% 	Copyright:			by authors - not released for commercial use
	% 	Version:			1 
	% 	Known bugs:		
	% 	Report bugs to:		Wanhammar@gmail.com
	
	ewT = exp(-i*wT);
	ewT2 = exp(-i*wT*2);	
	%	b = 2*(alfa(1,1)+alfa(1,2)-1);
	%	Denom = ewT2 + b*ewT - 2*alfa(1,1) + 1;
	%	s11 = ((1-alfa(1,1))*ewT2 + b*ewT + 1 - alfa(1,1))./Denom;
	%	s22 = s11;
	%	s21 = (alfa(1,1)*(1-ewT2))./Denom;
	%	s12 = s21;
	t = -1;
	s11 = 1;	s22 = 1;	s21 = 0;	s12 = 0;
	for k = 1:length(alfa(:,1))
		if t == -1, 		
			disp('Shunt arm:')
			alfa(k,:)
		else 
			disp('Serikes arm:')
			alfa(k,:)		
		end
		b = 2*(alfa(k,1)+alfa(k,2)-1);
		Denom = ewT2 + b*ewT - 2*alfa(k,1) + 1;
		s211 = ((1-alfa(k,1))*ewT2 + b*ewT + 1 - alfa(k,1))./Denom;
		s222 = s211;
		s221 = (t*alfa(k,1)*(1-ewT2))./Denom;
		s212 = s221;
		A = s212.*s21+s211.*s11;
		s21 = s222.*s21+s221.*s11;
		s11 = A;
		B = s212.*s22+s211.*s12;	
		s22 = s222.*s22+s221.*s12;
		s12 = B;
		t = -t;
	end


